/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/    

/*
 * Test Routines for SD cards on DM814X EVM.
 * 
 */

#include "DM814x_types.h"
#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "sdmmc.h"

#define HSMMC_BASE1		0x481D8000
#define TEST_PATTERN	0xAB

int main (void)
{
	INT32 cardtype;
	INT32 is_highcap_card = 0;	
	INT32 retval = FAILURE;
	INT32 sdmmc_rwtest (hsmmc_t *base, INT32 highcap_card);


	printf ("SDMMC Tests:\n");
	printf ("*) The test verifies the command, clock and data lines of sd/mmc by writing and verifies the data written\n");
	printf ("*) Ensure that the Boot Switches are selected as specified in the README\n");
	printf ("*) Ensure that an SD card is inserted into the Base Board of your EVM\n\n");

	printf ("Running SDMMC Tests:\n");
	mmcinit((hsmmc_t *) HSMMC_BASE1);
	
	cardtype = detect_card((hsmmc_t *) HSMMC_BASE1, &is_highcap_card);
	switch (cardtype) {
	case MMC_CARD:
		printf ("\tMMC Card Detected\n");
		break;
	case SD_CARD:
		printf ("\tSD Card Detected\n");
		retval = sdmmc_rwtest((hsmmc_t *)HSMMC_BASE1, is_highcap_card);
		break;
	case SDIO_CARD:
		retval = FAILURE;
		printf ("\tSDIO Card Detected\n");
		printf ("Please Insert an SDIO Card and run this program again!\n");
		break;
	case UNKNOWN_CARD:
	default:
		retval = FAILURE;
		printf ("\tUnable to communicate with the card\n");
		printf ("\tEnsure that an SD card is inserted into the Base Board of your EVM\n");
		break;
	}
	
	if (retval == SUCCESS)
		printf ("\nSDMMC Test Passed\n");
	else
		printf ("\nSDMMC Test Failed\n");

}

INT32 sdmmc_rwtest (hsmmc_t *base, INT32 highcap_card)
{
	UINT8 writebuf[SECTOR_SIZE], readbuf[SECTOR_SIZE];
	UINT8 savebuf[SECTOR_SIZE];
	INT32 retval;
	INT32 block = 1;
	
	memset (writebuf, TEST_PATTERN, sizeof(writebuf));
	memset (readbuf, 0x00, sizeof(readbuf));
	
	retval = bread (base, highcap_card, block, SECTOR_SIZE, savebuf);
	if (retval < 0) {
		printf ("\tUnable to Read Block data\n");
		return FAILURE;
	}

	printf ("\tSDMMC: Writing a pattern to Block %d....", block);
	retval = bwrite (base, highcap_card, block, SECTOR_SIZE, writebuf);
	if (retval == SUCCESS)
		printf ("Write test passed\n");
	else {
		printf ("Unable to Write Sector\n");
		return FAILURE;
	}
	
	printf ("\tSDMMC: Reading from Block %d...", block);
	retval = bread (base, highcap_card, block, SECTOR_SIZE, readbuf);
	if (retval == SUCCESS)
		printf ("Read test passed\n");
	else {
		printf ("Unable to Read Sector\n");
		return FAILURE;
	}
	
	retval = bwrite (base, highcap_card, block, SECTOR_SIZE, savebuf);
	if (retval == FAILURE) {
		printf ("\tUnable to restore the original contents of the SDMMC card\n");
		return FAILURE;
	}
		
	if (memcmp(writebuf, readbuf, SECTOR_SIZE) == 0) {
		printf ("\tVerify data...Passed\n");
		return SUCCESS;
	} else {
		printf ("\tVerify data...Failed\n");
		return FAILURE;
	}
}
